import type { ITimestampStruct } from '../clock';
import { NodeBuilder } from './DelayedValueBuilder';
export declare namespace nodes {
    class con<T extends unknown | ITimestampStruct> extends NodeBuilder {
        readonly raw: T;
        readonly type = "con";
        constructor(raw: T);
    }
    class str<T extends string = string> extends NodeBuilder {
        readonly raw: T;
        readonly type = "str";
        constructor(raw: T);
    }
    class bin extends NodeBuilder {
        readonly raw: Uint8Array;
        readonly type = "bin";
        constructor(raw: Uint8Array);
    }
    class val<T extends NodeBuilder> extends NodeBuilder {
        readonly value: T;
        readonly type = "val";
        constructor(value: T);
    }
    class vec<T extends NodeBuilder[]> extends NodeBuilder {
        readonly value: T;
        readonly type = "vec";
        constructor(value: T);
    }
    class obj<T extends Record<string, NodeBuilder>, O extends Record<string, NodeBuilder> = {}> extends NodeBuilder {
        readonly obj: T;
        readonly opt?: O | undefined;
        readonly type = "obj";
        constructor(obj: T, opt?: O | undefined);
        optional<OO extends Record<string, NodeBuilder>>(): obj<T, O & OO>;
    }
    class arr<T extends NodeBuilder> extends NodeBuilder {
        readonly arr: T[];
        readonly type = "arr";
        constructor(arr: T[]);
    }
}
export declare const schema: {
    con: <T extends unknown>(raw: T) => nodes.con<T>;
    str: <T_1 extends string>(str: T_1) => nodes.str<T_1>;
    bin: (bin: Uint8Array) => nodes.bin;
    val: <T_2 extends NodeBuilder>(val: T_2) => nodes.val<T_2>;
    vec: <T_3 extends NodeBuilder[]>(...vec: T_3) => nodes.vec<T_3>;
    obj: <T_4 extends Record<string, NodeBuilder>, O extends Record<string, NodeBuilder>>(obj: T_4, opt?: O | undefined) => nodes.obj<T_4, O>;
    arr: <T_5 extends NodeBuilder>(arr: T_5[]) => nodes.arr<T_5>;
};
export declare const s: {
    con: <T extends unknown>(raw: T) => nodes.con<T>;
    str: <T_1 extends string>(str: T_1) => nodes.str<T_1>;
    bin: (bin: Uint8Array) => nodes.bin;
    val: <T_2 extends NodeBuilder>(val: T_2) => nodes.val<T_2>;
    vec: <T_3 extends NodeBuilder[]>(...vec: T_3) => nodes.vec<T_3>;
    obj: <T_4 extends Record<string, NodeBuilder>, O extends Record<string, NodeBuilder>>(obj: T_4, opt?: O | undefined) => nodes.obj<T_4, O>;
    arr: <T_5 extends NodeBuilder>(arr: T_5[]) => nodes.arr<T_5>;
};
