import { ITimestampStruct, IVectorClock } from '../../clock';
import { CrdtReader } from '../../util/binary/CrdtReader';
import { CrdtWriter } from '../../util/binary/CrdtWriter';
export declare class ClockTableEntry {
    index: number;
    id: ITimestampStruct;
    constructor(index: number, id: ITimestampStruct);
}
export declare class ClockTable {
    static from(clock: IVectorClock): ClockTable;
    static decode(reader: CrdtReader): ClockTable;
    readonly bySid: Map<number, ClockTableEntry>;
    readonly byIdx: ITimestampStruct[];
    parseField(field: `${string}_${string}`): ITimestampStruct;
    push(id: ITimestampStruct): void;
    getBySid(sid: number): ClockTableEntry;
    write(writer: CrdtWriter): void;
}
