"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decode = void 0;
const fromBase64_1 = require("../../../util/base64/fromBase64");
const clock_1 = require("../../clock");
const PatchBuilder_1 = require("../../PatchBuilder");
const decodeId = (time) => typeof time === 'number' ? (0, clock_1.ts)(1, time) : (0, clock_1.ts)(time[0], time[1]);
const decode = (data) => {
    const { id, ops } = data;
    const clock = typeof id === 'number' ? new clock_1.ServerVectorClock(1, id) : new clock_1.VectorClock(id[0], id[1]);
    const builder = new PatchBuilder_1.PatchBuilder(clock);
    for (const op of ops) {
        switch (op.op) {
            case 'new_con': {
                if (op.timestamp) {
                    builder.const(decodeId(op.value));
                }
                else {
                    builder.const(op.value);
                }
                break;
            }
            case 'new_val': {
                builder.val();
                break;
            }
            case 'new_obj': {
                builder.obj();
                break;
            }
            case 'new_vec': {
                builder.vec();
                break;
            }
            case 'new_str': {
                builder.str();
                break;
            }
            case 'new_bin': {
                builder.bin();
                break;
            }
            case 'new_arr': {
                builder.arr();
                break;
            }
            case 'ins_val': {
                builder.setVal(decodeId(op.obj), decodeId(op.value));
                break;
            }
            case 'ins_obj': {
                builder.insObj(decodeId(op.obj), op.value.map(([key, id]) => [key, decodeId(id)]));
                break;
            }
            case 'ins_vec': {
                builder.insVec(decodeId(op.obj), op.value.map(([key, id]) => [key, decodeId(id)]));
                break;
            }
            case 'ins_str': {
                builder.insStr(decodeId(op.obj), decodeId(op.after || op.obj), op.value);
                break;
            }
            case 'ins_bin': {
                builder.insBin(decodeId(op.obj), decodeId(op.after || op.obj), (0, fromBase64_1.fromBase64)(op.value));
                break;
            }
            case 'ins_arr': {
                builder.insArr(decodeId(op.obj), decodeId(op.after || op.obj), op.values.map(decodeId));
                break;
            }
            case 'del': {
                builder.del(decodeId(op.obj), op.what.map((spans) => (0, clock_1.tss)(...spans)));
                break;
            }
            case 'nop': {
                builder.nop(op.len || 1);
                break;
            }
        }
    }
    const patch = builder.patch;
    patch.meta = data.meta;
    return patch;
};
exports.decode = decode;
