"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NopOp = exports.DelOp = exports.InsArrOp = exports.InsBinOp = exports.InsStrOp = exports.InsVecOp = exports.InsObjOp = exports.InsValOp = exports.NewArrOp = exports.NewBinOp = exports.NewStrOp = exports.NewVecOp = exports.NewObjOp = exports.NewValOp = exports.NewConOp = void 0;
const clock_1 = require("./clock");
class NewConOp {
    constructor(id, val) {
        this.id = id;
        this.val = val;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_con';
    }
    toString(tab = '') {
        const val = this.val;
        const valFormatted = val instanceof clock_1.Timestamp
            ? `{ ${(0, clock_1.toDisplayString)(val)} }`
            : val instanceof Uint8Array
                ? val.length < 13
                    ? `Uint8Array { ${('' + val).replaceAll(',', ', ')} }`
                    : `Uint8Array(${val.length})`
                : `{ ${JSON.stringify(val)} }`;
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)} ${valFormatted}`;
    }
}
exports.NewConOp = NewConOp;
class NewValOp {
    constructor(id) {
        this.id = id;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_val';
    }
    toString() {
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}`;
    }
}
exports.NewValOp = NewValOp;
class NewObjOp {
    constructor(id) {
        this.id = id;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_obj';
    }
    toString() {
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}`;
    }
}
exports.NewObjOp = NewObjOp;
class NewVecOp {
    constructor(id) {
        this.id = id;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_vec';
    }
    toString() {
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}`;
    }
}
exports.NewVecOp = NewVecOp;
class NewStrOp {
    constructor(id) {
        this.id = id;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_str';
    }
    toString() {
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}`;
    }
}
exports.NewStrOp = NewStrOp;
class NewBinOp {
    constructor(id) {
        this.id = id;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_bin';
    }
    toString(tab = '') {
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}`;
    }
}
exports.NewBinOp = NewBinOp;
class NewArrOp {
    constructor(id) {
        this.id = id;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_arr';
    }
    toString() {
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}`;
    }
}
exports.NewArrOp = NewArrOp;
class InsValOp {
    constructor(id, obj, val) {
        this.id = id;
        this.obj = obj;
        this.val = val;
    }
    span() {
        return 1;
    }
    name() {
        return 'ins_val';
    }
    toString(tab = '') {
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}!${this.span()}, obj = ${(0, clock_1.toDisplayString)(this.obj)}, val = ${(0, clock_1.toDisplayString)(this.val)}`;
    }
}
exports.InsValOp = InsValOp;
class InsObjOp {
    constructor(id, obj, data) {
        this.id = id;
        this.obj = obj;
        this.data = data;
    }
    span() {
        return 1;
    }
    name() {
        return 'ins_obj';
    }
    toString(tab = '') {
        let out = `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}!${this.span()}, obj = ${(0, clock_1.toDisplayString)(this.obj)}`;
        for (let i = 0; i < this.data.length; i++) {
            const isLast = i === this.data.length - 1;
            out += `\n${tab}  ${isLast ? '└─' : '├─'} ${JSON.stringify(this.data[i][0])}: ${(0, clock_1.toDisplayString)(this.data[i][1])}`;
        }
        return out;
    }
}
exports.InsObjOp = InsObjOp;
class InsVecOp {
    constructor(id, obj, data) {
        this.id = id;
        this.obj = obj;
        this.data = data;
    }
    span() {
        return 1;
    }
    name() {
        return 'ins_vec';
    }
    toString(tab = '') {
        let out = `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}!${this.span()}, obj = ${(0, clock_1.toDisplayString)(this.obj)}`;
        for (let i = 0; i < this.data.length; i++) {
            const isLast = i === this.data.length - 1;
            out += `\n${tab}  ${isLast ? '└─' : '├─'} ${JSON.stringify(this.data[i][0])}: ${(0, clock_1.toDisplayString)(this.data[i][1])}`;
        }
        return out;
    }
}
exports.InsVecOp = InsVecOp;
class InsStrOp {
    constructor(id, obj, ref, data) {
        this.id = id;
        this.obj = obj;
        this.ref = ref;
        this.data = data;
    }
    span() {
        return this.data.length;
    }
    name() {
        return 'ins_str';
    }
    toString() {
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}!${this.span()}, obj = ${(0, clock_1.toDisplayString)(this.obj)} { ${(0, clock_1.toDisplayString)(this.ref)} ← ${JSON.stringify(this.data)} }`;
    }
}
exports.InsStrOp = InsStrOp;
class InsBinOp {
    constructor(id, obj, ref, data) {
        this.id = id;
        this.obj = obj;
        this.ref = ref;
        this.data = data;
    }
    span() {
        return this.data.length;
    }
    name() {
        return 'ins_bin';
    }
    toString(tab = '') {
        const ref = (0, clock_1.toDisplayString)(this.ref);
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}!${this.span()}, obj = ${(0, clock_1.toDisplayString)(this.obj)} { ${ref} ← ${this.data} }`;
    }
}
exports.InsBinOp = InsBinOp;
class InsArrOp {
    constructor(id, obj, ref, data) {
        this.id = id;
        this.obj = obj;
        this.ref = ref;
        this.data = data;
    }
    span() {
        return this.data.length;
    }
    name() {
        return 'ins_arr';
    }
    toString() {
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}!${this.span()}, obj = ${(0, clock_1.toDisplayString)(this.obj)} { ${(0, clock_1.toDisplayString)(this.ref)} ← ${this.data.map(clock_1.toDisplayString).join(', ')} }`;
    }
}
exports.InsArrOp = InsArrOp;
class DelOp {
    constructor(id, obj, what) {
        this.id = id;
        this.obj = obj;
        this.what = what;
    }
    span() {
        return 1;
    }
    name() {
        return 'del';
    }
    toString() {
        const spans = this.what.map((span) => (0, clock_1.toDisplayString)(span) + '!' + span.span).join(', ');
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}, obj = ${(0, clock_1.toDisplayString)(this.obj)} { ${spans} }`;
    }
}
exports.DelOp = DelOp;
class NopOp {
    constructor(id, len) {
        this.id = id;
        this.len = len;
    }
    span() {
        return this.len;
    }
    name() {
        return 'nop';
    }
    toString() {
        return `"${this.name()}" ${(0, clock_1.toDisplayString)(this.id)}!${this.len}`;
    }
}
exports.NopOp = NopOp;
