"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("../..");
const Encoder_1 = require("../../codec/structural/verbose/Encoder");
const util_1 = require("util");
const encoder = new Encoder_1.Encoder();
const model = __1.Model.withLogicalClock(123);
model.api.root({
    time: 123456,
    name: 'Vadim',
    verified: true,
    tags: [],
});
console.clear();
console.log('');
console.log(model.toString());
console.log('');
console.log('View:');
console.log(model.view());
console.log('');
console.log('"verbose" encoded:');
const json = encoder.encode(model);
console.log((0, util_1.inspect)(json, false, 20, true));
console.log('');
console.log('View size:', JSON.stringify(model.view()).length);
console.log('"verbose" size:', JSON.stringify(json).length);
console.log('"binary" size:', model.toBinary().length);
