"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("..");
const json_crdt_patch_1 = require("../../json-crdt-patch");
const clock_1 = require("../../json-crdt-patch/clock");
const model = __1.Model.withLogicalClock(1234);
model.api.root({
    num: 123,
    bool: true,
    nil: null,
});
console.log(model.view());
console.log(model.toString());
model.api.root({
    str: 'hello',
    obj: { foo: 'bar' },
    arr: [1],
});
console.log(model + '');
console.log(model.view());
model.api.root({
    str: (0, json_crdt_patch_1.konst)('hello'),
    obj: (0, json_crdt_patch_1.konst)({ foo: 'bar' }),
    arr: (0, json_crdt_patch_1.konst)([1]),
});
console.log(model + '');
console.log(model.view());
model.api.root({
    undef: undefined,
    stamp: (0, json_crdt_patch_1.konst)(new clock_1.Timestamp(1234, 5678)),
});
console.log(model + '');
console.log(model.view());
model.api.root({
    foo: {
        bar: 42,
    },
});
console.log(model + '');
console.log(model.view());
const conApi = model.api.const(['foo', 'bar']);
console.log(conApi.view());
console.log(conApi.node.toString());
