"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("..");
const json_crdt_patch_1 = require("../../json-crdt-patch");
const schema = json_crdt_patch_1.s.obj({
    text: json_crdt_patch_1.s.con('hello'),
    counter: json_crdt_patch_1.s.con(0),
    checked: json_crdt_patch_1.s.con(true),
    friend: json_crdt_patch_1.s.obj({
        name: json_crdt_patch_1.s.con('John'),
        age: json_crdt_patch_1.s.con(42),
        tags: json_crdt_patch_1.s.arr([json_crdt_patch_1.s.con('foo'), json_crdt_patch_1.s.con('bar')]),
    }),
});
const model = __1.Model.withLogicalClock(1234).setSchema(schema);
console.log(model + '');
console.log(model.view().friend.name);
console.log(model.view().friend.tags[1]);
console.log(model.api.node.get('text').view());
console.log(model.api.node.get('friend').get('name').view());
