import * as nodes from '../../../nodes';
import { ClockEncoder } from '../../../../json-crdt-patch/codec/clock/ClockEncoder';
import { ITimestampStruct } from '../../../../json-crdt-patch/clock';
import type * as t from './types';
import type { Model } from '../../../model';
export declare class Encoder {
    protected time?: number;
    protected clock?: ClockEncoder;
    protected model: Model;
    encode(model: Model): t.JsonCrdtCompactDocument;
    protected ts(ts: ITimestampStruct): t.JsonCrdtCompactTimestamp;
    protected cNode(node: nodes.JsonNode): t.JsonCrdtCompactNode;
    protected cObj(obj: nodes.ObjNode): t.JsonCrdtCompactObj;
    protected cVec(vec: nodes.VecNode): t.JsonCrdtCompactVec;
    protected cArr(node: nodes.ArrNode): t.JsonCrdtCompactArr;
    protected cStr(node: nodes.StrNode): t.JsonCrdtCompactStr;
    protected cBin(node: nodes.BinNode): t.JsonCrdtCompactBin;
    protected cVal(node: nodes.ValNode): t.JsonCrdtCompactVal;
    protected cCon(node: nodes.ConNode): t.JsonCrdtCompactCon;
}
