import type { Model } from '../model';
import type { Operation, OperationAdd, OperationRemove, OperationReplace, OperationMove, OperationCopy, OperationTest, OperationStrIns, OperationStrDel } from '../../json-patch';
import { PatchBuilder } from '../../json-crdt-patch/PatchBuilder';
export declare class JsonPatch {
    protected readonly model: Model;
    constructor(model: Model);
    apply(ops: Operation[]): this;
    applyOp(op: Operation): this;
    protected builder(): PatchBuilder;
    applyOpAdd(op: OperationAdd): void;
    applyRemove(op: OperationRemove): void;
    applyReplace(op: OperationReplace): void;
    applyMove(op: OperationMove): void;
    applyCopy(op: OperationCopy): void;
    applyTest(op: OperationTest): void;
    applyStrIns(op: OperationStrIns): void;
    applyStrDel(op: OperationStrDel): void;
    private get;
    private json;
    private setRoot;
}
