"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ObjNode = void 0;
const clock_1 = require("../../../json-crdt-patch/clock");
const printTree_1 = require("../../../util/print/printTree");
class ObjNode {
    constructor(doc, id) {
        this.doc = doc;
        this.id = id;
        this.keys = new Map();
        this._tick = 0;
        this._view = {};
        this.api = undefined;
    }
    get(key) {
        const id = this.keys.get(key);
        if (!id)
            return undefined;
        return this.doc.index.get(id);
    }
    put(key, id) {
        const currentId = this.keys.get(key);
        if (currentId && (0, clock_1.compare)(currentId, id) >= 0)
            return;
        this.keys.set(key, id);
        return currentId;
    }
    nodes(callback) {
        const index = this.doc.index;
        this.keys.forEach((id, key) => callback(index.get(id), key));
    }
    children(callback) {
        const index = this.doc.index;
        this.keys.forEach((id, key) => callback(index.get(id)));
    }
    child() {
        return undefined;
    }
    container() {
        return this;
    }
    view() {
        const doc = this.doc;
        const tick = doc.clock.time + doc.tick;
        const _view = this._view;
        if (this._tick === tick)
            return _view;
        const view = {};
        const index = doc.index;
        let useCache = true;
        this.keys.forEach((id, key) => {
            const value = index.get(id).view();
            if (value !== undefined) {
                if (_view[key] !== value)
                    useCache = false;
                view[key] = value;
            }
            else if (_view[key] !== undefined)
                useCache = false;
        });
        return useCache ? _view : ((this._tick = tick), (this._view = view));
    }
    toString(tab = '') {
        const header = this.constructor.name + ' ' + (0, clock_1.toDisplayString)(this.id);
        return (header +
            (0, printTree_1.printTree)(tab, [...this.keys.entries()].map(([key, id]) => (tab) => JSON.stringify(key) + (0, printTree_1.printTree)(tab + ' ', [(tab) => this.doc.index.get(id).toString(tab)]))));
    }
}
exports.ObjNode = ObjNode;
