"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StrNode = exports.StrChunk = void 0;
const clock_1 = require("../../../json-crdt-patch/clock");
const AbstractRga_1 = require("../rga/AbstractRga");
const util_1 = require("../../../util/trees/util");
class StrChunk {
    constructor(id, span, str) {
        this.id = id;
        this.span = span;
        this.len = str ? span : 0;
        this.del = !str;
        this.p = undefined;
        this.l = undefined;
        this.r = undefined;
        this.p2 = undefined;
        this.l2 = undefined;
        this.r2 = undefined;
        this.s = undefined;
        this.data = str;
    }
    merge(str) {
        this.data += str;
        this.span = this.data.length;
    }
    split(ticks) {
        if (!this.del) {
            const chunk = new StrChunk((0, clock_1.tick)(this.id, ticks), this.span - ticks, this.data.slice(ticks));
            this.data = this.data.slice(0, ticks);
            this.span = ticks;
            return chunk;
        }
        const chunk = new StrChunk((0, clock_1.tick)(this.id, ticks), this.span - ticks, '');
        this.span = ticks;
        return chunk;
    }
    delete() {
        this.del = true;
        this.data = '';
    }
    clone() {
        const chunk = new StrChunk(this.id, this.span, this.data);
        return chunk;
    }
}
exports.StrChunk = StrChunk;
class StrNode extends AbstractRga_1.AbstractRga {
    constructor() {
        super(...arguments);
        this._view = '';
        this.api = undefined;
    }
    children() { }
    child() {
        return undefined;
    }
    container() {
        return undefined;
    }
    view() {
        if (this._view)
            return this._view;
        let str = '';
        for (let chunk = this.first(); chunk; chunk = (0, util_1.next)(chunk))
            str += chunk.data;
        return (this._view = str);
    }
    createChunk(id, str) {
        return new StrChunk(id, str ? str.length : 0, str || '');
    }
    onChange() {
        this._view = '';
    }
    toStringName() {
        return super.toStringName();
    }
}
exports.StrNode = StrNode;
