"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.inputOperators = void 0;
const tslib_1 = require("tslib");
const codegen_steps_1 = require("../codegen-steps");
const util = tslib_1.__importStar(require("../util"));
const jsonPointer = tslib_1.__importStar(require("../../json-pointer"));
const find_1 = require("../../json-pointer/codegen/find");
const get = (vars, varname) => {
    if (typeof varname !== 'string')
        throw new Error('varname must be a string.');
    const [name, pointer] = util.parseVar(varname);
    jsonPointer.validateJsonPointer(pointer);
    const data = vars.get(name);
    const path = jsonPointer.toPath(pointer);
    const value = jsonPointer.get(data, path);
    return value;
};
exports.inputOperators = [
    [
        '$',
        ['get'],
        [1, 2],
        (expr, ctx) => {
            const varname = ctx.eval(expr[1], ctx);
            const defval = ctx.eval(expr[2], ctx);
            const value = get(ctx.vars, varname);
            return util.throwOnUndef(value, defval);
        },
        (ctx) => {
            ctx.link(util.throwOnUndef, 'throwOnUndef');
            const varname = ctx.operands[0];
            if (varname instanceof codegen_steps_1.Literal) {
                if (typeof varname.val !== 'string')
                    throw new Error('varname must be a string.');
                const [name, pointer] = util.parseVar(varname.val);
                jsonPointer.validateJsonPointer(pointer);
                const hasDefaultValue = ctx.expr.length === 3;
                const defaultValue = hasDefaultValue ? ctx.operands[1] : undefined;
                const fn = (0, find_1.$$find)(jsonPointer.toPath(pointer));
                const find = ctx.const(fn);
                const data = `vars.get(${JSON.stringify(name)})`;
                return new codegen_steps_1.Expression(`throwOnUndef(${find}(${data}),(${defaultValue}))`);
            }
            ctx.link(get, 'get');
            return new codegen_steps_1.Expression(`throwOnUndef(get(vars,(${varname})),(${ctx.operands[1]}))`);
        },
        true,
    ],
    [
        '$?',
        ['get?'],
        1,
        (expr, ctx) => {
            const varname = ctx.eval(expr[1], ctx);
            const value = get(ctx.vars, varname);
            return value !== undefined;
        },
        (ctx) => {
            const varname = ctx.operands[0];
            if (varname instanceof codegen_steps_1.Literal) {
                if (typeof varname.val !== 'string')
                    throw new Error('varname must be a string.');
                const [name, pointer] = util.parseVar(varname.val);
                jsonPointer.validateJsonPointer(pointer);
                const fn = (0, find_1.$$find)(jsonPointer.toPath(pointer));
                const find = ctx.const(fn);
                const data = `vars.get(${JSON.stringify(name)})`;
                return new codegen_steps_1.Expression(`${find}(${data})!==undefined`);
            }
            ctx.link(get, 'get');
            return new codegen_steps_1.Expression(`get(vars,(${varname}))!==undefined`);
        },
        true,
    ],
];
