import type { CompactOpBase } from '../codec/compact/types';
import type { Path } from '../../json-pointer';
import type { OpType } from '../opcodes';
import type { Operation } from '../types';
import { OPCODE } from '../constants';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare abstract class AbstractOp<O extends OpType = OpType> {
    readonly path: Path;
    readonly from?: Path;
    constructor(path: Path);
    abstract op(): O;
    abstract code(): OPCODE;
    abstract apply(doc: unknown): {
        doc: unknown;
        old?: unknown;
    };
    abstract toJson(parent?: AbstractOp): Operation;
    abstract toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactOpBase;
    abstract encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
