"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpIn = void 0;
const json_pointer_1 = require("../../json-pointer");
const AbstractPredicateOp_1 = require("./AbstractPredicateOp");
const deepEqual_1 = require("../../json-equal/deepEqual");
class OpIn extends AbstractPredicateOp_1.AbstractPredicateOp {
    constructor(path, value) {
        super(path);
        this.value = value;
    }
    op() {
        return 'in';
    }
    code() {
        return 33;
    }
    test(doc) {
        const { val } = (0, json_pointer_1.find)(doc, this.path);
        for (const x of this.value)
            if ((0, deepEqual_1.deepEqual)(val, x))
                return true;
        return false;
    }
    toJson(parent) {
        const op = {
            op: 'in',
            path: (0, json_pointer_1.formatJsonPointer)(parent ? this.path.slice(parent.path.length) : this.path),
            value: this.value,
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'in' : 33;
        return [opcode, parent ? this.path.slice(parent.path.length) : this.path, this.value];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(33);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
        encoder.encodeArray(this.value);
    }
}
exports.OpIn = OpIn;
