import type { CompactSplitOp } from '../codec/compact/types';
import { AbstractOp } from './AbstractOp';
import { OperationSplit } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpSplit extends AbstractOp<'split'> {
    readonly pos: number;
    readonly props: object | null;
    constructor(path: Path, pos: number, props: object | null);
    op(): "split";
    code(): OPCODE;
    apply(doc: unknown): {
        doc: unknown;
        old: {} | null;
    };
    private split;
    toJson(parent?: AbstractOp): OperationSplit;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactSplitOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
