import type { CompactTestStringOp } from '../codec/compact/types';
import { AbstractPredicateOp } from './AbstractPredicateOp';
import { OperationTestString } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import { AbstractOp } from './AbstractOp';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpTestString extends AbstractPredicateOp<'test_string'> {
    readonly pos: number;
    readonly str: string;
    readonly not: boolean;
    constructor(path: Path, pos: number, str: string, not: boolean);
    op(): "test_string";
    code(): OPCODE;
    test(doc: unknown): boolean;
    toJson(parent?: AbstractOp): OperationTestString;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactTestStringOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
