"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stringify = void 0;
const escape_1 = require("../util/strings/escape");
const insertion_1 = require("../util/sort/insertion");
const getKeys = Object.keys;
const stringify = (val) => {
    let i, max, str, keys, key, propVal;
    switch (typeof val) {
        case 'string':
            return ('"' + (0, escape_1.escape)(val) + '"');
        case 'object':
            if (val instanceof Array) {
                str = '[';
                max = val.length - 1;
                for (i = 0; i < max; i++)
                    str += (0, exports.stringify)(val[i]) + ',';
                if (max >= 0)
                    str += (0, exports.stringify)(val[i]);
                return (str + ']');
            }
            if (val === null)
                return 'null';
            keys = (0, insertion_1.sort)(getKeys(val));
            max = keys.length;
            str = '{';
            i = 0;
            while (i < max) {
                key = keys[i];
                propVal = (0, exports.stringify)(val[key]);
                if (i && str !== '')
                    str += ',';
                str += '"' + (0, escape_1.escape)(key) + '":' + propVal;
                i++;
            }
            return (str + '}');
        default:
            return String(val);
    }
};
exports.stringify = stringify;
