"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamStdout = void 0;
const tslib_1 = require("tslib");
const json_pointer_1 = require("../../json-pointer");
class CliParamStdout {
    constructor() {
        this.param = 'stdout';
        this.short = 'out';
        this.title = 'Write data to STDOUT';
        this.example = '--out=/foo';
        this.createInstance = (cli, _, rawValue) => {
            return new (class {
                constructor() {
                    this.onResponse = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const pointer = String(rawValue);
                        (0, json_pointer_1.validateJsonPointer)(pointer);
                        const path = (0, json_pointer_1.toPath)(pointer);
                        cli.response = (0, json_pointer_1.find)(cli.response, path).val;
                    });
                }
            })();
        };
    }
}
exports.CliParamStdout = CliParamStdout;
