"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatError = void 0;
const Value_1 = require("../reactive-rpc/common/messages/Value");
const caller_1 = require("../reactive-rpc/common/rpc/caller");
const formatError = (err) => {
    if (err instanceof Value_1.Value)
        return (0, exports.formatError)(err.data);
    if (err instanceof caller_1.RpcError)
        return err.toJson();
    if (err instanceof Error)
        return { message: err.message, stack: err.stack };
    return err;
};
exports.formatError = formatError;
