import type { Observable } from 'rxjs';
import type { Mutable } from '../../util/types';
import type { Display, Identifiable } from './common';
import type { Expr } from '../../json-expression';
export interface TType<Value = unknown> extends Display, Partial<Identifiable> {
    __t: string;
    examples?: TExample<Value>[];
}
export interface TExample<Value = unknown> extends Display {
    value: Value;
}
export interface WithValidator {
    validator?: string | string[];
}
export interface AnySchema extends TType<unknown>, WithValidator {
    __t: 'any';
    metadata?: Record<string, unknown>;
}
export interface BooleanSchema extends TType<boolean>, WithValidator {
    __t: 'bool';
}
export interface NumberSchema extends TType<number>, WithValidator {
    __t: 'num';
    format?: 'i' | 'u' | 'f' | 'i8' | 'i16' | 'i32' | 'i64' | 'u8' | 'u16' | 'u32' | 'u64' | 'f32' | 'f64';
    gt?: number;
    gte?: number;
    lt?: number;
    lte?: number;
}
export interface StringSchema extends TType<string>, WithValidator {
    __t: 'str';
    ascii?: boolean;
    noJsonEscape?: boolean;
    min?: number;
    max?: number;
}
export interface BinarySchema<T extends TType = any> extends TType, WithValidator {
    __t: 'bin';
    type: T;
    format?: 'json' | 'cbor' | 'msgpack' | 'ion';
}
export interface ArraySchema<T extends TType = any> extends TType<Array<unknown>>, WithValidator {
    __t: 'arr';
    type: T;
    min?: number;
    max?: number;
}
export interface ConstSchema<V = any> extends TType, WithValidator {
    __t: 'const';
    value: V;
}
export interface TupleSchema<T extends TType[] = any> extends TType, WithValidator {
    __t: 'tup';
    types: T;
}
export interface ObjectSchema<Fields extends ObjectFieldSchema<string, TType>[] | readonly ObjectFieldSchema<string, TType>[] = any> extends TType<object>, WithValidator {
    __t: 'obj';
    fields: Fields;
    unknownFields?: boolean;
    encodeUnknownFields?: boolean;
}
export interface ObjectFieldSchema<K extends string = string, V extends TType = TType> extends TType<[K, V]>, Display {
    __t: 'field';
    key: K;
    type: V;
    optional?: boolean;
}
export interface ObjectOptionalFieldSchema<K extends string = string, V extends TType = TType> extends ObjectFieldSchema<K, V> {
    optional: true;
}
export interface RefSchema<T extends TType = TType> extends TType {
    __t: 'ref';
    ref: string & T;
}
export interface OrSchema<T extends TType[] = TType[]> extends TType {
    __t: 'or';
    types: T;
    discriminator: Expr;
}
export type FunctionValue<Req, Res, Ctx = unknown> = (req: Req, ctx?: Ctx) => Res | Promise<Res>;
export interface FunctionSchema<Req extends TType = TType, Res extends TType = TType> extends TType {
    __t: 'fn';
    req: Req;
    res: Res;
}
export type FunctionStreamingValue<Req, Res, Ctx = unknown> = (req: Observable<Req>, ctx?: Ctx) => Observable<Res>;
export interface FunctionStreamingSchema<Req extends TType = TType, Res extends TType = TType> extends TType {
    __t: 'fn$';
    req: Req;
    res: Res;
}
export interface TypeSystemSchema {
    types: {};
}
export type JsonSchema = BooleanSchema | NumberSchema | StringSchema | BinarySchema | ArraySchema | ConstSchema | TupleSchema | ObjectSchema | ObjectFieldSchema | ObjectOptionalFieldSchema;
export type Schema = JsonSchema | RefSchema | OrSchema | AnySchema | FunctionSchema | FunctionStreamingSchema;
export type NoT<T extends TType> = Omit<T, '__t'>;
export type TypeOf<T> = T extends OrSchema<any> ? TypeOfValue<T['types'][number]> : T extends RefSchema<infer U> ? TypeOf<U> : T extends AnySchema ? unknown : TypeOfValue<T>;
export type TypeOfValue<T> = T extends BooleanSchema ? boolean : T extends NumberSchema ? number : T extends StringSchema ? string : T extends ArraySchema<infer U> ? TypeOf<U>[] : T extends ConstSchema<infer U> ? U : T extends TupleSchema<infer U> ? {
    [K in keyof U]: TypeOf<U[K]>;
} : T extends ObjectSchema<infer F> ? NoEmptyInterface<TypeFields<Mutable<F>>> : T extends BinarySchema ? Uint8Array : T extends FunctionSchema<infer Req, infer Res> ? (req: TypeOf<Req>, ctx?: unknown) => Promise<TypeOf<Res>> : T extends FunctionStreamingSchema<infer Req, infer Res> ? (req$: Observable<TypeOf<Req>>, ctx?: unknown) => Observable<TypeOf<Res>> : never;
export type TypeOfMap<M extends Record<string, Schema>> = {
    [K in keyof M]: TypeOf<M[K]>;
};
type TypeFields<F> = TypeOfFieldMap<FieldsAdjustedForOptional<ToObject<{
    [K in keyof F]: ObjectFieldToTuple<F[K]>;
}>>>;
type ToObject<T> = T extends [string, unknown][] ? {
    [K in T[number] as K[0]]: K[1];
} : never;
type ObjectFieldToTuple<F> = F extends ObjectFieldSchema<infer K, infer V> ? [K, F] : never;
type NoEmptyInterface<I> = keyof I extends never ? Record<string, never> : I;
type OptionalFields<T> = {
    [K in keyof T]-?: T[K] extends ObjectOptionalFieldSchema ? K : never;
}[keyof T];
type RequiredFields<T> = Exclude<keyof T, OptionalFields<T>>;
type FieldsAdjustedForOptional<T> = Pick<T, RequiredFields<T>> & Partial<Pick<T, OptionalFields<T>>>;
type TypeOfFieldMap<T> = {
    [K in keyof T]: TypeOf<FieldValue<T[K]>>;
};
type FieldValue<F> = F extends ObjectFieldSchema<any, infer V> ? V : never;
export type OptionalProps<T extends object> = Exclude<{
    [K in keyof T]: T extends Record<K, T[K]> ? never : K;
}[keyof T], undefined>;
export type Optional<T extends object> = Pick<T, OptionalProps<T>>;
export type Required<T extends object> = Omit<T, OptionalProps<T>>;
export {};
