import { WebSocketState } from './constants';
export interface CreateWebSocketMockParams {
    onClose: (code?: number, reason?: string) => void;
    onSend: (data: string | ArrayBufferLike | Blob | ArrayBufferView) => void;
}
export interface MockWebSocket extends WebSocket {
    readonly _protocol: string | string[];
    _readyState: WebSocketState;
    _bufferedAmount: number;
    _extendParams(newParams: Partial<CreateWebSocketMockParams>): void;
    _open(): void;
    _close(code: number, reason: string, wasClean: boolean): void;
    _error(): void;
    _message(message: string | ArrayBuffer | ArrayBufferView): void;
}
export declare const createWebSocketMock: (params: Partial<CreateWebSocketMockParams>) => {
    new (url: string, _protocol?: string | string[]): {
        readonly CONNECTING: 0;
        readonly OPEN: 1;
        readonly CLOSING: 2;
        readonly CLOSED: 3;
        onclose: null;
        onerror: null;
        onmessage: null;
        onopen: null;
        binaryType: 'arraybuffer' | 'blob';
        _readyState: WebSocketState;
        _bufferedAmount: number;
        readonly bufferedAmount: number;
        readonly extensions: string;
        readonly protocol: string;
        readonly readyState: number;
        readonly url: string;
        readonly _protocol: string | string[];
        close(code?: number, reason?: string): void;
        send(data: string | ArrayBufferLike | Blob | ArrayBufferView): void;
        addEventListener(): void;
        removeEventListener(): void;
        dispatchEvent(): boolean;
        _extendParams(newParams: Partial<CreateWebSocketMockParams>): void;
        _open(): void;
        _close(code: number, reason: string, wasClean: boolean): void;
        _error(): void;
        _message(message: string | ArrayBuffer | ArrayBufferView): void;
    };
    readonly CONNECTING: 0;
    readonly OPEN: 1;
    readonly CLOSING: 2;
    readonly CLOSED: 3;
};
