import * as msg from '../messages';
import type { RpcCaller } from './caller/RpcCaller';
export type IncomingBatchMessage = msg.RequestDataMessage | msg.RequestCompleteMessage | msg.RequestErrorMessage | msg.NotificationMessage;
export type OutgoingBatchMessage = msg.ResponseCompleteMessage | msg.ResponseErrorMessage;
export interface RpcMessageBatchProcessorOptions<Ctx = unknown> {
    caller: RpcCaller<Ctx>;
}
export declare class RpcMessageBatchProcessor<Ctx = unknown> {
    protected readonly caller: RpcCaller<Ctx>;
    constructor({ caller }: RpcMessageBatchProcessorOptions<Ctx>);
    onBatch(list: IncomingBatchMessage[], ctx: Ctx): Promise<OutgoingBatchMessage[]>;
    onNotification(message: msg.NotificationMessage, ctx: Ctx): void;
    onRequest(message: msg.RequestDataMessage | msg.RequestCompleteMessage | msg.RequestErrorMessage, ctx: Ctx): Promise<OutgoingBatchMessage>;
}
