import { Observable, ReplaySubject } from 'rxjs';
import { StreamingRpcClientOptions } from './client/StreamingRpcClient';
import { RpcDuplex } from '../rpc/RpcDuplex';
import { RpcMessageStreamProcessorOptions } from './RpcMessageStreamProcessor';
import { PersistentChannel, PersistentChannelParams } from '../channel';
import { RpcCodec } from '../codec/RpcCodec';
export interface RpcPersistentClientParams<Ctx = unknown> {
    channel: PersistentChannelParams;
    codec: RpcCodec;
    client?: Omit<StreamingRpcClientOptions, 'send'>;
    server?: Omit<RpcMessageStreamProcessorOptions<Ctx>, 'send'>;
    ping?: number;
}
export declare class RpcPersistentClient<Ctx = unknown> {
    channel: PersistentChannel;
    rpc?: RpcDuplex<Ctx>;
    readonly rpc$: ReplaySubject<RpcDuplex<Ctx>>;
    constructor(params: RpcPersistentClientParams<Ctx>);
    call$(method: string, data: unknown | Observable<unknown>): Observable<unknown>;
    call(method: string, data: unknown): Promise<unknown>;
    notify(method: string, data: unknown): void;
    start(): void;
    stop(): void;
}
