import { RpcCaller, RpcApiCallerOptions } from './RpcCaller';
import { FunctionStreamingType, FunctionType } from '../../../../json-type/type/classes';
import { StaticRpcMethod, type StaticRpcMethodOptions } from '../methods/StaticRpcMethod';
import { StreamingRpcMethod, type StreamingRpcMethodOptions } from '../methods/StreamingRpcMethod';
import type { SchemaOf, TypeMap, TypeOf, TypeSystem } from '../../../../json-type';
export interface TypedApiCallerOptions<Ctx = unknown> extends Omit<RpcApiCallerOptions<Ctx>, 'getMethod'> {
    system: TypeSystem;
}
type MethodReq<F> = F extends FunctionType<infer Req, any> ? TypeOf<SchemaOf<Req>> : F extends FunctionStreamingType<infer Req, any> ? TypeOf<SchemaOf<Req>> : never;
type MethodRes<F> = F extends FunctionType<any, infer Res> ? TypeOf<SchemaOf<Res>> : F extends FunctionStreamingType<any, infer Res> ? TypeOf<SchemaOf<Res>> : never;
type MethodDefinition<Ctx, F> = F extends FunctionType<any, any> ? StaticRpcMethodOptions<Ctx, MethodReq<F>, MethodRes<F>> : F extends FunctionStreamingType<any, any> ? StreamingRpcMethodOptions<Ctx, MethodReq<F>, MethodRes<F>> : never;
export declare class TypedApiCaller<Types extends TypeMap, Ctx = unknown> extends RpcCaller<Ctx> {
    protected readonly system: TypeSystem;
    protected readonly methods: Map<string, StaticRpcMethod<Ctx, unknown, unknown> | StreamingRpcMethod<Ctx, unknown, unknown>>;
    constructor({ system, ...rest }: TypedApiCallerOptions<Ctx>);
    readonly req: {
        [K in keyof Types]: MethodReq<Types[K]>;
    };
    readonly res: {
        [K in keyof Types]: MethodRes<Types[K]>;
    };
    implement<K extends keyof Types>(id: K, definition_: MethodDefinition<Ctx, Types[K]>): void;
    get<K extends keyof Types>(id: K): MethodDefinition<Ctx, Types[K]>;
}
export {};
