"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncodedStaticRpcClient = void 0;
const tslib_1 = require("tslib");
class EncodedStaticRpcClient {
    constructor({ send, msgCodec, reqCodec, resCodec = reqCodec, client }) {
        this.client = client;
        client.onsend = (messages) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const buf = msgCodec.encode(reqCodec, messages);
            const res = yield send(buf);
            const resultMessages = msgCodec.decodeBatch(resCodec, res);
            return resultMessages;
        });
    }
    call$(method, data) {
        return this.client.call$(method, data);
    }
    call(method, request) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return this.call(method, request);
        });
    }
    notify(method, data) {
        this.notify(method, data);
    }
}
exports.EncodedStaticRpcClient = EncodedStaticRpcClient;
