"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FetchRpcClient = void 0;
const tslib_1 = require("tslib");
const StaticRpcClient_1 = require("./StaticRpcClient");
const EncodedStaticRpcClient_1 = require("./EncodedStaticRpcClient");
class FetchRpcClient {
    constructor(options) {
        const { msgCodec, reqCodec, resCodec = reqCodec, url } = options;
        let contentType = `application/x.rpc.${msgCodec.id}.${reqCodec.id}`;
        if (reqCodec.id !== resCodec.id)
            contentType += `-${resCodec.id}`;
        const myFetch = options.fetch || fetch;
        this.client = new EncodedStaticRpcClient_1.EncodedStaticRpcClient({
            client: new StaticRpcClient_1.StaticRpcClient({
                bufferSize: options.bufferSize,
                bufferTime: options.bufferTime,
            }),
            msgCodec,
            reqCodec,
            resCodec,
            send: (body) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                const response = yield myFetch(url, {
                    method: 'POST',
                    headers: {
                        'Content-Type': contentType,
                    },
                    body,
                });
                const buffer = yield response.arrayBuffer();
                return new Uint8Array(buffer);
            }),
        });
    }
    call$(method, data) {
        return this.client.call$(method, data);
    }
    call(method, request) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return this.call(method, request);
        });
    }
    notify(method, data) {
        this.notify(method, data);
    }
}
exports.FetchRpcClient = FetchRpcClient;
