"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimedQueue = void 0;
class TimedQueue {
    constructor() {
        this.itemLimit = 100;
        this.timeLimit = 5;
        this.onFlush = (list) => { };
        this.list = [];
        this.timer = null;
    }
    push(item) {
        this.list.push(item);
        if (this.list.length >= this.itemLimit) {
            this.flush();
            return;
        }
        if (!this.timer) {
            this.timer = setTimeout(() => {
                this.flush();
            }, this.timeLimit);
        }
    }
    flush() {
        const list = this.list;
        this.list = [];
        if (this.timer)
            clearTimeout(this.timer);
        this.timer = null;
        if (list.length)
            this.onFlush(list);
        return list;
    }
}
exports.TimedQueue = TimedQueue;
