"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.subscribeSyncObserver = void 0;
const microtask_1 = require("./microtask");
function subscribeSyncObserver(observable, observer) {
    let completed = false;
    let buffer = [];
    const flush = () => {
        if (!buffer.length)
            return;
        observer.next(buffer, completed);
        buffer = [];
    };
    return observable.subscribe({
        next: (data) => {
            buffer.push(data);
            if (buffer.length === 1)
                (0, microtask_1.microtask)(flush);
        },
        error: (error) => {
            flush();
            observer.error(error);
        },
        complete: () => {
            completed = true;
            flush();
            observer.complete();
        },
    });
}
exports.subscribeSyncObserver = subscribeSyncObserver;
