"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Emitter = void 0;
class Emitter {
    constructor() {
        this.et = new EventTarget();
    }
    on(type, listener, options) {
        this.et.addEventListener(type, listener, options);
    }
    emit(event) {
        return this.et.dispatchEvent(event);
    }
    off(type, listener, options) {
        this.et.removeEventListener(type, listener, options);
    }
}
exports.Emitter = Emitter;
