"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RouterCodegenOpts = exports.RouterCodegenCtx = void 0;
const codegen_1 = require("../codegen");
const JsExpression_1 = require("../codegen/util/JsExpression");
class RouterCodegenCtx {
    constructor() {
        this.codegen = new codegen_1.Codegen({
            args: ['str'],
            prologue: 'str = "" + str; var len = str.length|0;',
            epilogue: 'return undefined;',
        });
    }
}
exports.RouterCodegenCtx = RouterCodegenCtx;
class RouterCodegenOpts {
    constructor(slice, offset, depth = 0) {
        this.slice = slice;
        this.offset = offset;
        this.depth = depth;
    }
    create(offset) {
        const slice = new JsExpression_1.JsExpression(() => `str.slice(${offset})`);
        return new RouterCodegenOpts(slice, offset, this.depth + 1);
    }
}
exports.RouterCodegenOpts = RouterCodegenOpts;
