"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegexStep = exports.UntilStep = exports.ExactStep = void 0;
class ExactStep {
    constructor(text) {
        this.text = text;
    }
    toText() {
        return this.text;
    }
}
exports.ExactStep = ExactStep;
class UntilStep {
    constructor(name, until) {
        this.name = name;
        this.until = until;
    }
    toText() {
        const until = this.until === '\n' ? '\\n' : this.until;
        return `{${this.name}::${until}}`;
    }
}
exports.UntilStep = UntilStep;
class RegexStep {
    constructor(name, regex, until) {
        this.name = name;
        this.regex = regex;
        this.until = until;
    }
    toText() {
        const regex = this.regex || this.until ? ':' + this.regex : '';
        const until = this.until ? ':' + this.until : '';
        return `{${this.name}${regex}${until}}`;
    }
}
exports.RegexStep = RegexStep;
