import * as React from 'react';
import type { TransformType } from './hooks/useImageTransform';
import type { ImagePreviewType } from './Image';
import type { ImageElementProps } from './interface';
import type { PreviewProps, ToolbarRenderInfoType } from './Preview';
export interface PreviewGroupPreview extends Omit<ImagePreviewType, 'icons' | 'mask' | 'maskClassName' | 'onVisibleChange' | 'toolbarRender' | 'imageRender'> {
    /**
     * If Preview the show img index
     * @default 0
     */
    current?: number;
    countRender?: (current: number, total: number) => React.ReactNode;
    toolbarRender?: (originalNode: React.ReactElement, info: ToolbarRenderInfoType) => React.ReactNode;
    imageRender?: (originalNode: React.ReactElement, info: {
        transform: TransformType;
        current: number;
    }) => React.ReactNode;
    onVisibleChange?: (value: boolean, prevValue: boolean, current: number) => void;
    onChange?: (current: number, prevCurrent: number) => void;
}
export interface GroupConsumerProps {
    previewPrefixCls?: string;
    icons?: PreviewProps['icons'];
    items?: (string | ImageElementProps)[];
    fallback?: string;
    preview?: boolean | PreviewGroupPreview;
    children?: React.ReactNode;
}
declare const Group: React.FC<GroupConsumerProps>;
export default Group;
