import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import classNames from 'classnames';
import * as React from 'react';
import PanelContext from "../PanelContext";
import { getCellDateDisabled } from "../utils/dateUtil";
import { getLastDay } from "../utils/timeUtil";
export default function PanelBody(_ref) {
  var prefixCls = _ref.prefixCls,
    disabledDate = _ref.disabledDate,
    onSelect = _ref.onSelect,
    picker = _ref.picker,
    rowNum = _ref.rowNum,
    colNum = _ref.colNum,
    prefixColumn = _ref.prefixColumn,
    rowClassName = _ref.rowClassName,
    baseDate = _ref.baseDate,
    getCellClassName = _ref.getCellClassName,
    getCellText = _ref.getCellText,
    getCellNode = _ref.getCellNode,
    getCellDate = _ref.getCellDate,
    generateConfig = _ref.generateConfig,
    titleCell = _ref.titleCell,
    headerCells = _ref.headerCells;
  var _React$useContext = React.useContext(PanelContext),
    onDateMouseEnter = _React$useContext.onDateMouseEnter,
    onDateMouseLeave = _React$useContext.onDateMouseLeave,
    mode = _React$useContext.mode;
  var cellPrefixCls = "".concat(prefixCls, "-cell");

  // =============================== Body ===============================
  var rows = [];
  for (var i = 0; i < rowNum; i += 1) {
    var row = [];
    var rowStartDate = void 0;
    var _loop = function _loop() {
      var _objectSpread2;
      var offset = i * colNum + j;
      var currentDate = getCellDate(baseDate, offset);
      var disabled = getCellDateDisabled({
        cellDate: currentDate,
        mode: mode,
        disabledDate: disabledDate,
        generateConfig: generateConfig
      });
      if (j === 0) {
        rowStartDate = currentDate;
        if (prefixColumn) {
          row.push(prefixColumn(rowStartDate));
        }
      }
      var title = titleCell && titleCell(currentDate);
      var inner = /*#__PURE__*/React.createElement("div", {
        className: "".concat(cellPrefixCls, "-inner")
      }, getCellText(currentDate));
      row.push( /*#__PURE__*/React.createElement("td", {
        key: j,
        title: title,
        className: classNames(cellPrefixCls, _objectSpread((_objectSpread2 = {}, _defineProperty(_objectSpread2, "".concat(cellPrefixCls, "-disabled"), disabled), _defineProperty(_objectSpread2, "".concat(cellPrefixCls, "-start"), getCellText(currentDate) === 1 || picker === 'year' && Number(title) % 10 === 0), _defineProperty(_objectSpread2, "".concat(cellPrefixCls, "-end"), title === getLastDay(generateConfig, currentDate) || picker === 'year' && Number(title) % 10 === 9), _objectSpread2), getCellClassName(currentDate))),
        onClick: function onClick() {
          if (!disabled) {
            onSelect(currentDate);
          }
        },
        onMouseEnter: function onMouseEnter() {
          if (!disabled && onDateMouseEnter) {
            onDateMouseEnter(currentDate);
          }
        },
        onMouseLeave: function onMouseLeave() {
          if (!disabled && onDateMouseLeave) {
            onDateMouseLeave(currentDate);
          }
        }
      }, getCellNode ? getCellNode(currentDate, inner) : inner));
    };
    for (var j = 0; j < colNum; j += 1) {
      _loop();
    }
    rows.push( /*#__PURE__*/React.createElement("tr", {
      key: i,
      className: rowClassName && rowClassName(rowStartDate)
    }, row));
  }
  return /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefixCls, "-body")
  }, /*#__PURE__*/React.createElement("table", {
    className: "".concat(prefixCls, "-content")
  }, headerCells && /*#__PURE__*/React.createElement("thead", null, /*#__PURE__*/React.createElement("tr", null, headerCells)), /*#__PURE__*/React.createElement("tbody", null, rows)));
}