"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof3 = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _classnames = _interopRequireDefault(require("classnames"));
var _useMergedState7 = _interopRequireDefault(require("rc-util/lib/hooks/useMergedState"));
var _KeyCode = _interopRequireDefault(require("rc-util/lib/KeyCode"));
var _warning = _interopRequireDefault(require("rc-util/lib/warning"));
var React = _interopRequireWildcard(require("react"));
var _useCellRender = require("./hooks/useCellRender");
var _PanelContext = _interopRequireDefault(require("./PanelContext"));
var _DatePanel = _interopRequireDefault(require("./panels/DatePanel"));
var _DatetimePanel = _interopRequireDefault(require("./panels/DatetimePanel"));
var _DecadePanel = _interopRequireDefault(require("./panels/DecadePanel"));
var _MonthPanel = _interopRequireDefault(require("./panels/MonthPanel"));
var _MonthBody = require("./panels/MonthPanel/MonthBody");
var _QuarterPanel = _interopRequireDefault(require("./panels/QuarterPanel"));
var _TimePanel = _interopRequireDefault(require("./panels/TimePanel"));
var _WeekPanel = _interopRequireDefault(require("./panels/WeekPanel"));
var _YearPanel = _interopRequireDefault(require("./panels/YearPanel"));
var _RangeContext = _interopRequireDefault(require("./RangeContext"));
var _dateUtil = require("./utils/dateUtil");
var _getExtraFooter = _interopRequireDefault(require("./utils/getExtraFooter"));
var _getRanges = _interopRequireDefault(require("./utils/getRanges"));
var _timeUtil = require("./utils/timeUtil");
var _uiUtil = require("./utils/uiUtil");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof3(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Logic:
 *  When `mode` === `picker`,
 *  click will trigger `onSelect` (if value changed trigger `onChange` also).
 *  Panel change will not trigger `onSelect` but trigger `onPanelChange`
 */

// TMP type to fit for ts 3.9.2

// Calendar picker type
var CALENDAR_PANEL_MODE = ['date', 'month'];
function PickerPanel(props) {
  var _classNames;
  var _ref = props,
    _ref$prefixCls = _ref.prefixCls,
    prefixCls = _ref$prefixCls === void 0 ? 'rc-picker' : _ref$prefixCls,
    className = _ref.className,
    style = _ref.style,
    locale = _ref.locale,
    generateConfig = _ref.generateConfig,
    value = _ref.value,
    defaultValue = _ref.defaultValue,
    pickerValue = _ref.pickerValue,
    defaultPickerValue = _ref.defaultPickerValue,
    disabledDate = _ref.disabledDate,
    mode = _ref.mode,
    _ref$picker = _ref.picker,
    picker = _ref$picker === void 0 ? 'date' : _ref$picker,
    _ref$tabIndex = _ref.tabIndex,
    tabIndex = _ref$tabIndex === void 0 ? 0 : _ref$tabIndex,
    showNow = _ref.showNow,
    showTime = _ref.showTime,
    showToday = _ref.showToday,
    renderExtraFooter = _ref.renderExtraFooter,
    hideHeader = _ref.hideHeader,
    onSelect = _ref.onSelect,
    onChange = _ref.onChange,
    onPanelChange = _ref.onPanelChange,
    onMouseDown = _ref.onMouseDown,
    onPickerValueChange = _ref.onPickerValueChange,
    _onOk = _ref.onOk,
    components = _ref.components,
    direction = _ref.direction,
    _ref$hourStep = _ref.hourStep,
    hourStep = _ref$hourStep === void 0 ? 1 : _ref$hourStep,
    _ref$minuteStep = _ref.minuteStep,
    minuteStep = _ref$minuteStep === void 0 ? 1 : _ref$minuteStep,
    _ref$secondStep = _ref.secondStep,
    secondStep = _ref$secondStep === void 0 ? 1 : _ref$secondStep,
    dateRender = _ref.dateRender,
    monthCellRender = _ref.monthCellRender,
    cellRender = _ref.cellRender;
  var needConfirmButton = picker === 'date' && !!showTime || picker === 'time';
  var isHourStepValid = 24 % hourStep === 0;
  var isMinuteStepValid = 60 % minuteStep === 0;
  var isSecondStepValid = 60 % secondStep === 0;

  // ============================ Warning ============================
  if (process.env.NODE_ENV !== 'production') {
    (0, _warning.default)(!value || generateConfig.isValidate(value), 'Invalidate date pass to `value`.');
    (0, _warning.default)(!value || generateConfig.isValidate(value), 'Invalidate date pass to `defaultValue`.');
    (0, _warning.default)(isHourStepValid, "`hourStep` ".concat(hourStep, " is invalid. It should be a factor of 24."));
    (0, _warning.default)(isMinuteStepValid, "`minuteStep` ".concat(minuteStep, " is invalid. It should be a factor of 60."));
    (0, _warning.default)(isSecondStepValid, "`secondStep` ".concat(secondStep, " is invalid. It should be a factor of 60."));
    (0, _warning.default)(!defaultPickerValue, "'defaultPickerValue' is deprecated. Please use 'defaultValue' instead.");
    (0, _warning.default)(!dateRender, "'dateRender' is deprecated. Please use 'cellRender' instead.");
    (0, _warning.default)(!monthCellRender, "'monthCellRender' is deprecated. Please use 'cellRender' instead.");
  }

  // ============================ State =============================

  var panelContext = React.useContext(_PanelContext.default);
  var operationRef = panelContext.operationRef,
    onContextSelect = panelContext.onSelect,
    hideRanges = panelContext.hideRanges,
    defaultOpenValue = panelContext.defaultOpenValue;
  var _React$useContext = React.useContext(_RangeContext.default),
    inRange = _React$useContext.inRange,
    panelPosition = _React$useContext.panelPosition,
    rangedValue = _React$useContext.rangedValue,
    hoverRangedValue = _React$useContext.hoverRangedValue;
  var panelRef = React.useRef({});

  // Handle init logic
  var initRef = React.useRef(true);

  // Value
  var _useMergedState = (0, _useMergedState7.default)(null, {
      value: value,
      defaultValue: defaultValue,
      postState: function postState(val) {
        if (!val && defaultOpenValue && picker === 'time') {
          return defaultOpenValue;
        }
        return val;
      }
    }),
    _useMergedState2 = (0, _slicedToArray2.default)(_useMergedState, 2),
    mergedValue = _useMergedState2[0],
    setInnerValue = _useMergedState2[1];

  // View date control
  var _useMergedState3 = (0, _useMergedState7.default)(null, {
      value: pickerValue,
      defaultValue: defaultPickerValue || mergedValue,
      postState: function postState(date) {
        var now = generateConfig.getNow();
        if (!date) {
          return now;
        }
        // When value is null and set showTime
        if (!mergedValue && showTime) {
          var defaultDateObject = (0, _typeof2.default)(showTime) === 'object' ? showTime.defaultValue : defaultValue;
          return (0, _timeUtil.setDateTime)(generateConfig, Array.isArray(date) ? date[0] : date, defaultDateObject || now);
        }
        return Array.isArray(date) ? date[0] : date;
      }
    }),
    _useMergedState4 = (0, _slicedToArray2.default)(_useMergedState3, 2),
    viewDate = _useMergedState4[0],
    setInnerViewDate = _useMergedState4[1];
  var setViewDate = function setViewDate(date) {
    setInnerViewDate(date);
    if (onPickerValueChange) {
      onPickerValueChange(date);
    }
  };

  // Panel control
  var getInternalNextMode = function getInternalNextMode(nextMode) {
    var getNextMode = _uiUtil.PickerModeMap[picker];
    if (getNextMode) {
      return getNextMode(nextMode);
    }
    return nextMode;
  };

  // Save panel is changed from which panel
  var _useMergedState5 = (0, _useMergedState7.default)(function () {
      if (picker === 'time') {
        return 'time';
      }
      return getInternalNextMode('date');
    }, {
      value: mode
    }),
    _useMergedState6 = (0, _slicedToArray2.default)(_useMergedState5, 2),
    mergedMode = _useMergedState6[0],
    setInnerMode = _useMergedState6[1];
  React.useEffect(function () {
    setInnerMode(picker);
  }, [picker]);
  var _React$useState = React.useState(function () {
      return mergedMode;
    }),
    _React$useState2 = (0, _slicedToArray2.default)(_React$useState, 2),
    sourceMode = _React$useState2[0],
    setSourceMode = _React$useState2[1];
  var onInternalPanelChange = function onInternalPanelChange(newMode, viewValue) {
    var nextMode = getInternalNextMode(newMode || mergedMode);
    setSourceMode(mergedMode);
    setInnerMode(nextMode);
    if (onPanelChange && (mergedMode !== nextMode || (0, _dateUtil.isEqual)(generateConfig, viewDate, viewDate))) {
      onPanelChange(viewValue, nextMode);
    }
  };
  var triggerSelect = function triggerSelect(date, type) {
    var forceTriggerSelect = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    if (mergedMode === picker || forceTriggerSelect) {
      setInnerValue(date);
      if (onSelect) {
        onSelect(date);
      }
      if (onContextSelect) {
        onContextSelect(date, type);
      }
      if (onChange && !(0, _dateUtil.isEqual)(generateConfig, date, mergedValue) && !(disabledDate !== null && disabledDate !== void 0 && disabledDate(date))) {
        onChange(date);
      }
    }
  };
  var isSelectable = function isSelectable(key) {
    if (CALENDAR_PANEL_MODE.includes(mergedMode)) {
      var _date;
      var operationFnc;
      var isDateMode = mergedMode === 'date';
      if (key === _KeyCode.default.PAGE_UP || key === _KeyCode.default.PAGE_DOWN) {
        operationFnc = isDateMode ? generateConfig.addMonth : generateConfig.addYear;
      } else {
        operationFnc = isDateMode ? generateConfig.addDate : generateConfig.addMonth;
      }
      switch (key) {
        case _KeyCode.default.LEFT:
        case _KeyCode.default.PAGE_UP:
          _date = operationFnc(viewDate, -1);
          break;
        case _KeyCode.default.RIGHT:
        case _KeyCode.default.PAGE_DOWN:
          _date = operationFnc(viewDate, 1);
          break;
        case _KeyCode.default.UP:
        case _KeyCode.default.DOWN:
          _date = operationFnc(viewDate, Number("".concat(key === _KeyCode.default.UP ? '-' : '').concat(isDateMode ? _dateUtil.WEEK_DAY_COUNT : _MonthBody.MONTH_COL_COUNT)));
          break;
      }
      if (_date) {
        return !(disabledDate !== null && disabledDate !== void 0 && disabledDate(_date));
      }
    }
    return true;
  };

  // ========================= Interactive ==========================
  var onInternalKeyDown = function onInternalKeyDown(e) {
    if (panelRef.current && panelRef.current.onKeyDown) {
      var selectable = true;
      var which = e.which;
      if ([_KeyCode.default.LEFT, _KeyCode.default.RIGHT, _KeyCode.default.UP, _KeyCode.default.DOWN, _KeyCode.default.PAGE_UP, _KeyCode.default.PAGE_DOWN, _KeyCode.default.ENTER].includes(which)) {
        e.preventDefault();
        if (which !== _KeyCode.default.ENTER && tabIndex === 0) {
          selectable = isSelectable(which);
        }
      }

      // Cannot use keyboard to select disabled date
      if (selectable) {
        return panelRef.current.onKeyDown(e);
      }
    }

    /* istanbul ignore next */
    /* eslint-disable no-lone-blocks */
    {
      (0, _warning.default)(false, 'Panel not correct handle keyDown event. Please help to fire issue about this.');
      return false;
    }
    /* eslint-enable no-lone-blocks */
  };

  var onInternalBlur = function onInternalBlur(e) {
    if (panelRef.current && panelRef.current.onBlur) {
      panelRef.current.onBlur(e);
    }
  };
  if (operationRef && panelPosition !== 'right') {
    operationRef.current = {
      onKeyDown: onInternalKeyDown,
      onClose: function onClose() {
        if (panelRef.current && panelRef.current.onClose) {
          panelRef.current.onClose();
        }
      }
    };
  }

  // ============================ Effect ============================
  React.useEffect(function () {
    if (value && !initRef.current) {
      setInnerViewDate(value);
    }
  }, [value]);
  React.useEffect(function () {
    initRef.current = false;
  }, []);

  // ============================ Panels ============================
  var panelNode;
  var mergedCellRender = (0, _useCellRender.useCellRender)({
    cellRender: cellRender,
    monthCellRender: monthCellRender,
    dateRender: dateRender
  });
  var pickerProps = (0, _objectSpread2.default)((0, _objectSpread2.default)({}, props), {}, {
    cellRender: mergedCellRender,
    operationRef: panelRef,
    prefixCls: prefixCls,
    viewDate: viewDate,
    value: mergedValue,
    onViewDateChange: setViewDate,
    sourceMode: sourceMode,
    onPanelChange: onInternalPanelChange,
    disabledDate: disabledDate
  });
  delete pickerProps.onChange;
  delete pickerProps.onSelect;
  switch (mergedMode) {
    case 'decade':
      panelNode = /*#__PURE__*/React.createElement(_DecadePanel.default, (0, _extends2.default)({}, pickerProps, {
        onSelect: function onSelect(date, type) {
          setViewDate(date);
          triggerSelect(date, type);
        }
      }));
      break;
    case 'year':
      panelNode = /*#__PURE__*/React.createElement(_YearPanel.default, (0, _extends2.default)({}, pickerProps, {
        onSelect: function onSelect(date, type) {
          setViewDate(date);
          triggerSelect(date, type);
        }
      }));
      break;
    case 'month':
      panelNode = /*#__PURE__*/React.createElement(_MonthPanel.default, (0, _extends2.default)({}, pickerProps, {
        onSelect: function onSelect(date, type) {
          setViewDate(date);
          triggerSelect(date, type);
        }
      }));
      break;
    case 'quarter':
      panelNode = /*#__PURE__*/React.createElement(_QuarterPanel.default, (0, _extends2.default)({}, pickerProps, {
        onSelect: function onSelect(date, type) {
          setViewDate(date);
          triggerSelect(date, type);
        }
      }));
      break;
    case 'week':
      panelNode = /*#__PURE__*/React.createElement(_WeekPanel.default, (0, _extends2.default)({}, pickerProps, {
        onSelect: function onSelect(date, type) {
          setViewDate(date);
          triggerSelect(date, type);
        }
      }));
      break;
    case 'time':
      delete pickerProps.showTime;
      panelNode = /*#__PURE__*/React.createElement(_TimePanel.default, (0, _extends2.default)({}, pickerProps, (0, _typeof2.default)(showTime) === 'object' ? showTime : null, {
        onSelect: function onSelect(date, type) {
          setViewDate(date);
          triggerSelect(date, type);
        }
      }));
      break;
    default:
      if (showTime) {
        panelNode = /*#__PURE__*/React.createElement(_DatetimePanel.default, (0, _extends2.default)({}, pickerProps, {
          onSelect: function onSelect(date, type) {
            setViewDate(date);
            triggerSelect(date, type);
          }
        }));
      } else {
        panelNode = /*#__PURE__*/React.createElement(_DatePanel.default, (0, _extends2.default)({}, pickerProps, {
          onSelect: function onSelect(date, type) {
            setViewDate(date);
            triggerSelect(date, type);
          }
        }));
      }
  }

  // ============================ Footer ============================
  var extraFooter;
  var rangesNode;
  var onNow = function onNow() {
    var now = generateConfig.getNow();
    var lowerBoundTime = (0, _timeUtil.getLowerBoundTime)(generateConfig.getHour(now), generateConfig.getMinute(now), generateConfig.getSecond(now), isHourStepValid ? hourStep : 1, isMinuteStepValid ? minuteStep : 1, isSecondStepValid ? secondStep : 1);
    var adjustedNow = (0, _timeUtil.setTime)(generateConfig, now, lowerBoundTime[0],
    // hour
    lowerBoundTime[1],
    // minute
    lowerBoundTime[2] // second
    );

    triggerSelect(adjustedNow, 'submit');
  };
  if (!hideRanges) {
    extraFooter = (0, _getExtraFooter.default)(prefixCls, mergedMode, renderExtraFooter);

    // This content is not displayed when the header switches year and month
    if (showTime && mergedMode !== 'date') {
      rangesNode = null;
    } else {
      rangesNode = (0, _getRanges.default)({
        prefixCls: prefixCls,
        components: components,
        needConfirmButton: needConfirmButton,
        okDisabled: !mergedValue || disabledDate && disabledDate(mergedValue),
        locale: locale,
        showNow: showNow,
        onNow: needConfirmButton && onNow,
        onOk: function onOk() {
          if (mergedValue) {
            triggerSelect(mergedValue, 'submit', true);
            if (_onOk) {
              _onOk(mergedValue);
            }
          }
        }
      });
    }
  }
  var todayNode;
  if (showToday && mergedMode === 'date' && picker === 'date' && !showTime) {
    var now = generateConfig.getNow();
    var todayCls = "".concat(prefixCls, "-today-btn");
    var disabled = disabledDate && disabledDate(now);
    todayNode = /*#__PURE__*/React.createElement("a", {
      className: (0, _classnames.default)(todayCls, disabled && "".concat(todayCls, "-disabled")),
      "aria-disabled": disabled,
      onClick: function onClick() {
        if (!disabled) {
          triggerSelect(now, 'mouse', true);
        }
      }
    }, locale.today);
  }
  return /*#__PURE__*/React.createElement(_PanelContext.default.Provider, {
    value: (0, _objectSpread2.default)((0, _objectSpread2.default)({}, panelContext), {}, {
      mode: mergedMode,
      hideHeader: 'hideHeader' in props ? hideHeader : panelContext.hideHeader,
      hidePrevBtn: inRange && panelPosition === 'right',
      hideNextBtn: inRange && panelPosition === 'left'
    })
  }, /*#__PURE__*/React.createElement("div", {
    tabIndex: tabIndex,
    className: (0, _classnames.default)("".concat(prefixCls, "-panel"), className, (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-panel-has-range"), rangedValue && rangedValue[0] && rangedValue[1]), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-panel-has-range-hover"), hoverRangedValue && hoverRangedValue[0] && hoverRangedValue[1]), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-panel-rtl"), direction === 'rtl'), _classNames)),
    style: style,
    onKeyDown: onInternalKeyDown,
    onBlur: onInternalBlur,
    onMouseDown: onMouseDown
  }, panelNode, extraFooter || rangesNode || todayNode ? /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefixCls, "-footer")
  }, extraFooter, rangesNode, todayNode) : null));
}
var _default = exports.default = PickerPanel;
/* eslint-enable */