"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mutex = void 0;
const codeMutex_1 = require("./codeMutex");
/**
 * Executes only one instance of give code at a time. For parallel calls, it
 * returns the result of the ongoing execution.
 *
 * {@link mutex} can be used as a class method decorator or a higher order
 * function.
 */
function mutex(target, context) {
    const mut = (0, codeMutex_1.codeMutex)();
    return async function () {
        return await mut(async () => await target.call(this));
    };
}
exports.mutex = mutex;
