"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mutex = void 0;
const tslib_1 = require("tslib");
const codeMutex_1 = require("./codeMutex");
/**
 * Executes only one instance of give code at a time. For parallel calls, it
 * returns the result of the ongoing execution.
 *
 * {@link mutex} can be used as a class method decorator or a higher order
 * function.
 */
function mutex(target, context) {
    const mut = (0, codeMutex_1.codeMutex)();
    return function () {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return yield mut(() => tslib_1.__awaiter(this, void 0, void 0, function* () { return yield target.call(this); }));
        });
    };
}
exports.mutex = mutex;
