/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
import { Dirent } from 'fs';
import { IFS } from './fs';
import { Readable, Writable } from 'stream';
export interface IUnionFsError extends Error {
    prev?: IUnionFsError | null;
}
type readdirEntry = string | Buffer | Dirent;
/**
 * Union object represents a stack of filesystems
 */
export declare class Union {
    private fss;
    ReadStream: typeof Readable | (new (...args: any[]) => Readable);
    WriteStream: typeof Writable | (new (...args: any[]) => Writable);
    private promises;
    constructor();
    unwatchFile: (...args: any[]) => void;
    watch: (...args: any[]) => {};
    watchFile: (...args: any[]) => void;
    existsSync: (path: string) => boolean;
    readdir: (...args: any[]) => void;
    readdirSync: (...args: any[]) => Array<readdirEntry>;
    readdirPromise: (...args: any[]) => Promise<Array<readdirEntry>>;
    private pathFromReaddirEntry;
    private sortedArrayFromReaddirResult;
    createReadStream: (path: string) => import("fs").ReadStream;
    createWriteStream: (path: string) => import("fs").WriteStream;
    /**
     * Adds a filesystem to the list of filesystems in the union
     * The new filesystem object is added as the last filesystem used
     * when searching for a file.
     *
     * @param fs the filesystem interface to be added to the queue of FS's
     * @returns this instance of a unionFS
     */
    use(fs: IFS): this;
    private syncMethod;
    private asyncMethod;
    promiseMethod(method: string, args: any[]): Promise<any>;
}
export {};
